# Version 2.4 - 2.5

This update will break any project that has changed any of the following from the default plugin installation:
## The "Awaiting Payment" or "Paid" order statuses have been removed
### What breaks
Version `2.4.25.0` of EvCheckout added slugs to order statuses. It would have attempted to populate the slugs for the default order statuses EvCheckout provides in the installer. It checks for the Id and the name of the order status it would expect to find if the default order statuses haven't changed. If the order statuses have been removed then no slugs would have been populated and therefore when EvCheckout attempts to set an order status Id by slug, it will fail.
### How to fix
* Add new order statuses or add slugs to any custom order statuses (preferably through a migration).
* Update the `statusSlugs` values in the EvCheckout config file.
The unpaid status should be the order status to use while an order is currently going through the transaction process. The paid status should be the order status to use once an order has been paid. If you are using a different flow or recording payment status separately then these values can be the same.

## The "Awaiting Payment" or "Paid" order statuses have had their Ids changed so they no longer have Id 1 and 2.
### What breaks
Version `2.4.25.0` of EvCheckout added slugs to order statuses. It would have attempted to populate the slugs for the default order statuses EvCheckout provides in the installer. It checks for the Id and the name of the order status it would expect to find if the default order statuses haven't changed. If the order statuses have been removed then no slugs would have been populated and therefore when EvCheckout attempts to set an order status Id by slug, it will fail.
### How to fix
* Add slugs to any custom order statuses (preferably through a migration).
* Update the `statusSlugs` values in the EvCheckout config file.
The unpaid status should be the order status to use while an order is currently going through the transaction process. The paid status should be the order status to use once an order has been paid. If you are using a different flow or recording payment status separately then these values can be the same.

## The "Awaiting Payment" or "Paid" order statuses have been renamed from their default names.
### What breaks?
Version `2.4.25.0` of EvCheckout added slugs to order statuses. It would have attempted to populate the slugs for the default order statuses EvCheckout provides in the installer. It checks for the Id and the name of the order status it would expect to find if the default order statuses haven't changed. If the order statuses have been removed then no slugs would have been populated and therefore when EvCheckout attempts to set an order status Id by slug, it will fail.
### How to fix
* Add slugs to the order statuses (preferably through a migration).
* Update the `statusSlugs` values in the EvCheckout config file.
The unpaid status should be the order status to use while an order is currently going through the transaction process. The paid status should be the order status to use once an order has been paid. If you are using a different flow or recording payment status separately then these values can be the same.


## The EvEmail order confirmation templates haven't been added.
### What breaks?
EvCheckout has been using the EvEmail plugin for order status update emails since version `2.3.6.*`. A set of EvEmail email templates were added to the installer at this point so if the installer hasn't been run since then or the templates removed because they weren't used by default. The plugin config has been set up to use these templates by default so if they are missing, the order confirmation emails won't be sent out.
### How to fix
* Add EvEmail templates for the customer and for the admin order confirmation emails. They can copied from the installer or custom.
* Update the `statusUpdateEmails.paid.emailTemplate` values in the EvCheckout config file. These should be changed to use the new EvEmail template system names.

## The EvEmail order confirmation templates have had their system name changed.
### What breaks?
The plugin config has been set up to use the original default EvEmail email templates that have a certain system name. If the system name has changed then the templates won't be able to be found and the order confirmation emails won't be sent out.
### How to fix
* Update the `statusUpdateEmails.paid.emailTemplate` values in the EvCheckout config file. These should be changed to use the new EvEmail template system names.

## The "customerNewOrder" and "adminNewOrder" email templates have been overridden.
### What breaks?
Technically nothing breaks, however the order tempate that is used won't be the same as the overridden template so if any extra content has been added to the overridden template, it will be lost on the EvEmail template.
### How to fix
EvCheckout order status emails are constructed like so:

	CMS content
	{==content==}

where the content is constructed from the `statusUpdateEmails.paid.viewTemplates` array, where each element is appended one after the other in order. Any static email content should be moved into the CMS content and any dynamic content should be moved into elements and the element name added to the `viewTemplats` array. Any helpers that are required can be added through the email configuration in the EvCheckout config file. View the default plugin config file for examples of order status email configurations.

